//
//  BIPlayPauseButton.h
//  BIViews
//
//  Created by Eric Hochmeister on 28/03/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>


// Defines for the bindings - they define indices into the various C style areas for keeping track of the necessary things
#define   BIPlayPauseButtonBindingCount        1
#define   BIPlayPauseButtonActiveBinding    0x00
//... define more as necessary


@interface BIPlayPauseButton : NSView {

	NSRect _playPauseRect;
	NSRect _centeredRect;
	
	id _target;
	SEL _action;
	
	BOOL _isActive;
	BOOL _enabled;
	
	BOOL _mouseIsDown;
	BOOL _mouseIsOver;
	

	// Bindings support
	id          _observedObjects[BIPlayPauseButtonBindingCount];
	NSString*   _observedKeyPaths[BIPlayPauseButtonBindingCount];	
	
}

- (id)target;
- (void)setTarget:(id)aTarget;
- (SEL)action;
- (void)setAction:(SEL)anAction;

- (BOOL)isActive;
- (void)setIsActive:(BOOL)flag;

- (BOOL)isEnabled;
- (void)setEnabled:(BOOL)flag;

- (NSRect)playPauseRect;
- (void)setPlayPauseRect:(NSRect)aPlayPauseRect;



@end
